// Loader for F18A GPU version of Mandlebrot viewer
// Pretty much all init is done by the GPU
// All we need to do here is load the 9900 code into VDP RAM and start it

const unsigned char MANGPU[] = {
  0x02,0x00,0x11,0x00,0xC8,0x00,0x1E,0x2A,
  0x02,0x01,0x1B,0x66,0x06,0xA0,0x1B,0x72,
  0x06,0xA0,0x1B,0x20,0x06,0xA0,0x1B,0x54,
  0x06,0xA0,0x1B,0x9E,0x03,0x40,0xC0,0xCB,
  0x02,0x00,0x18,0x00,0x02,0x02,0x00,0x03,
  0x04,0xC1,0xDC,0x01,0x02,0x21,0x01,0x00,
  0x16,0xFC,0x06,0x02,0x16,0xF9,0x04,0xC0,
  0x02,0x01,0x0C,0x00,0x04,0xF0,0x06,0x01,
  0x16,0xFD,0x02,0x00,0x20,0x00,0x02,0x01,
  0x0C,0x00,0x04,0xF0,0x06,0x01,0x16,0xFD,
  0x04,0x53,0x02,0x0C,0xC0,0x00,0x02,0x0D,
  0x28,0x00,0x02,0x0E,0x50,0x00,0x02,0x0F,
  0xB0,0x00,0x04,0x5B,0x02,0xE2,0x06,0xFF,
  0x03,0x36,0x03,0x00,0x5B,0x00,0x00,0x00,
  0x02,0x03,0x60,0x00,0xDC,0xF1,0x16,0xFE,
  0x02,0x01,0xD0,0x00,0xD8,0x01,0x1B,0x00,
  0x04,0x5B,0x80,0x00,0x07,0x40,0x38,0x00,
  0xC0,0x80,0x02,0x42,0xF0,0x00,0x16,0x04,
  0x09,0xD1,0x0A,0x30,0xE0,0x01,0x04,0x5B,
  0x07,0x00,0x04,0x5B,0xC8,0x0B,0x1E,0x28,
  0xC8,0x0C,0x1E,0x20,0xC8,0x0D,0x1E,0x22,
  0xC8,0x0E,0x1E,0x24,0xC8,0x0F,0x1E,0x26,
  0x08,0x8E,0x04,0xC3,0xC0,0x4F,0x15,0x03,
  0x13,0x02,0x07,0x41,0x07,0x03,0x04,0xC0,
  0x02,0x02,0x00,0xC0,0x3C,0x02,0xC3,0xC0,
  0xC0,0xC3,0x13,0x01,0x05,0x0F,0x04,0xCA,
  0xC3,0x20,0x1E,0x20,0x04,0xC9,0x04,0xC6,
  0x04,0xC7,0x02,0x08,0x00,0x0E,0xC0,0x06,
  0x06,0xA0,0x1B,0x86,0x02,0x80,0xFF,0xFF,
  0x13,0x2D,0xC1,0x00,0xC0,0x07,0x06,0xA0,
  0x1B,0x86,0x02,0x80,0xFF,0xFF,0x13,0x26,
  0xC1,0x40,0x09,0x50,0xC0,0x44,0x09,0x51,
  0xA0,0x01,0x02,0x80,0x04,0x00,0x14,0x1E,
  0x06,0x08,0x13,0x1C,0xC0,0x04,0x60,0x05,
  0xA0,0x0C,0x04,0xC5,0xC0,0x46,0x20,0x60,
  0x1B,0x84,0x16,0x02,0x05,0x45,0x07,0x41,
  0xC0,0x87,0x20,0xA0,0x1B,0x84,0x16,0x02,
  0x05,0x45,0x07,0x42,0x38,0x42,0x09,0xD2,
  0x0A,0x31,0xE0,0x42,0x0A,0x11,0xC1,0x45,
  0x13,0x01,0x05,0x01,0xA0,0x4D,0xC1,0xC1,
  0xC1,0x80,0x10,0xCD,0x06,0xA0,0x1C,0x7C,
  0xA3,0x0E,0x05,0x89,0x02,0x89,0x01,0x00,
  0x16,0xC2,0xA3,0x4F,0x05,0x8A,0x02,0x8A,
  0x00,0xC0,0x16,0xBA,0xC2,0xE0,0x1E,0x28,
  0xC3,0x20,0x1E,0x20,0xC3,0x60,0x1E,0x22,
  0xC3,0xA0,0x1E,0x24,0xC3,0xE0,0x1E,0x26,
  0x04,0x5B,0x80,0x40,0x20,0x10,0x08,0x04,
  0x02,0x01,0xC2,0x08,0x13,0x22,0x05,0x88,
  0x0A,0xC8,0xC0,0xE0,0x1E,0x2A,0xC0,0x03,
  0x02,0x40,0xF0,0x00,0x02,0x80,0x10,0x00,
  0x13,0x0B,0x82,0x00,0x13,0x09,0xC0,0x03,
  0x02,0x40,0x0F,0x00,0x13,0x05,0x09,0x48,
  0x02,0x43,0xF0,0xFF,0xF0,0xC8,0x10,0x21,
  0x02,0x43,0x0F,0xFF,0xF0,0xC8,0xC0,0x89,
  0x02,0x42,0x00,0x07,0xD0,0xA2,0x1C,0x74,
  0x06,0xC2,0xD0,0xA0,0x1B,0x85,0xE0,0xC2,
  0x10,0x14,0xC0,0xE0,0x1E,0x2A,0xC0,0x03,
  0x02,0x40,0x0F,0x00,0x13,0x0E,0x02,0x43,
  0x00,0xFF,0x0A,0x40,0xF0,0xC0,0xC0,0x49,
  0x02,0x41,0x00,0x07,0x13,0x06,0x02,0x02,
  0x00,0x80,0xE0,0xC2,0x09,0x12,0x06,0x01,
  0x16,0xFC,0xC0,0x09,0x02,0x40,0x00,0x07,
  0x02,0x80,0x00,0x07,0x16,0x14,0x06,0xC3,
  0xC0,0x0A,0x0A,0x50,0xE0,0x0A,0x02,0x40,
  0xFF,0x07,0xC0,0x89,0x02,0x42,0x00,0x07,
  0xA0,0x09,0x60,0x02,0xC0,0x8B,0xD4,0x03,
  0x02,0x20,0x20,0x00,0x06,0xC3,0xD4,0x03,
  0x02,0x03,0x11,0x00,0xC2,0xC2,0xC8,0x03,
  0x1E,0x2A,0x04,0x5B,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

// helpers from libti99Coleco

// Write Address/Register
volatile __sfr __at 0xbf VDPWA;
// Write Data
volatile __sfr __at 0xbe VDPWD;
// sound chip (so we can mute it)
volatile __sfr __at 0xff SOUND;

// set VDP write address
inline void VDP_SET_ADDRESS_WRITE(unsigned int x)					{	VDPWA=((x)&0xff); VDPWA=(((x)>>8)|0x40); }
inline void VDP_SET_REGISTER(unsigned char r, unsigned char v)		{	VDPWA=(v); VDPWA=(0x80|(r)); }

void vdpmemcpy(int pAddr, const unsigned char *pSrc, int cnt) {
	VDP_SET_ADDRESS_WRITE(pAddr);
	while (cnt--) {
		VDPWD=*(pSrc++);
	}
}

int main() {
    // copy the program to VDP
    vdpmemcpy(0x1b02, MANGPU, sizeof(MANGPU));
    
    // unlock the F18A by writing pattern to register 57 twice
    // must not be interrupted - make sure your NMI doesn't hit it
    // either by not accessing VDP in NMI or waiting for a vblank
    VDP_SET_REGISTER(57, 0x1c);
    VDP_SET_REGISTER(57, 0x1c);

    // load the GPU address - when writing the second register it
    // will start.
    VDP_SET_REGISTER(54, 0x1b);     // MSB
    VDP_SET_REGISTER(55, 0x02);     // LSB - now it starts
    
    // and the CPU is 100% free to do anything - even access VDP if it wants
    // infinite loop
    for (;;) { }
    
    // make the compiler happy
    return 0;
}

// called automatically by crt0.S
void vdpinit() {
	volatile unsigned int x;
	
	// shut off the sound generator - if the cart skips the BIOS screen, this is needed.
	SOUND = 0x9f;
	SOUND = 0xbf;
	SOUND = 0xdf;
	SOUND = 0xff;

	// before touching VDP, a brief delay. This gives time for the F18A to finish
	// initializing before we touch the VDP itself. This is needed on the Coleco if
	// you don't use the BIOS startup delay. This is roughly 200ms.
	x=60000;
	while (++x != 0) { }		// counts till we loop at 65536
}
